/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX_EXTENSIONS_H
#define MX_EXTENSIONS_H

#include "myriexpress.h"

/* The following API might be merged in the official API (myriexpress.h)
 * in the future, modified or removed depending on the feedback.
 */

#define MX_HAS_ICONNECT_V2 1

MX_FUNC(mx_return_t) mx_iconnect(struct mx_endpoint *ep,
				 uint64_t nic_id,
				 uint32_t eid,
				 uint32_t key,
				 uint64_t match_info,
				 void *context,
				 mx_request_t *request);

/* complete all pending sends and matched receives related to one peer,
 * they will return to the application as completed with status != MX_STATUS_SUCCESS
 */
MX_FUNC(mx_return_t) mx_disconnect(mx_endpoint_t ep, mx_endpoint_addr_t addr);

enum mx_unexp_handler_action {
  MX_RECV_CONTINUE = 0,
  MX_RECV_FINISHED
};

typedef enum mx_unexp_handler_action mx_unexp_handler_action_t;

typedef mx_unexp_handler_action_t
(*mx_unexp_handler_t)(void *context, mx_endpoint_addr_t source,
		      uint64_t match_value, uint32_t length,
		      void * data_if_available);

/* Registers a handler to process unexpected messages. */
/* This function is supposed to replace mx_register_unexp_callback in the future. */
MX_FUNC(mx_return_t) mx_register_unexp_handler(mx_endpoint_t ep,
					       mx_unexp_handler_t handler,
					       void *context);

/* Forget the completion event when the request completes */

MX_FUNC(mx_return_t) mx_forget(mx_endpoint_t endpoint,
			       mx_request_t *request);

/* Force the progression when no MX call is running. */
MX_FUNC(mx_return_t) mx_progress(mx_endpoint_t ep);

/* Store a user-private pointer in a peer address */

MX_FUNC(mx_return_t) mx_set_endpoint_addr_context(mx_endpoint_addr_t endpoint_addr,
						  void *context);

MX_FUNC(mx_return_t) mx_get_endpoint_addr_context(mx_endpoint_addr_t endpoint_addr,
						  void **context);

/* Set a request or endpoint timeout */
MX_FUNC(mx_return_t) mx_set_request_timeout(mx_endpoint_t endpoint,
					    mx_request_t request, uint32_t milli_seconds);

#endif /* MX_EXTENSIONS_H */
